<?php
 
include_once 'conexao.php';

class ModeloExperienciaProfessor
{ 
       
	static public function mdlAddExperienciaProfessor($dados){ 
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO experienciaprofessor 
		(cargo, instituicao, dataInicio, dataTermino, dataCadastro,idUsuario) VALUES 
	  (:cargo, :instituicao, :dataInicio, :dataTermino,  :dataCadastro, :idUsuario)");
		$data = date("d-m-Y H:i:s");
		$stmt->bindParam(":cargo", $dados["cargo"], PDO::PARAM_STR);
		$stmt->bindParam(":instituicao", $dados["instituicao"], PDO::PARAM_STR);
		$stmt->bindParam(":dataInicio", $dados["dataInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":dataTermino", $dados["dataTermino"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $data, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $_SESSION['ID_usuario'], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok"; 

		}else{

			$errorInfo = $stmt->errorInfo();
  			return $errorInfo[2];
		
		}

	}



	static public function mdlVerificarSeExeperienciaJaExiste($cargo,$instituicao,$idUsuario){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM experienciaprofessor where cargo = :cargo and instituicao = :instituicao and idUsuario = :idUsuario");
			$stmt->bindParam(":cargo", $cargo, PDO::PARAM_STR);
			$stmt->bindParam(":instituicao", $instituicao, PDO::PARAM_STR);
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 

	static public function mdlMostrarFormacoesDoestudante($idUsuario){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM experienciaprofessor where idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute(); 

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	
	
	static public function mdlMostrarDadosDoFuncionarioPorIdFuncionario($idFuncionario){

		$resultado = array();

			$stmt = Conexao::conectar()->query("SELECT * FROM funcionario where idFuncionario = '$idFuncionario'");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	} 
 
	static public function mdlMostrarTodosUsuarioComLimite($limite){

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM usuario order by idUsuario desc limit $limite");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
	static public function mdlActualizarGrupoFuncionario($grupoDeTrabalho, $idFuncionario){ 
			
			$stmt = Conexao::conectar()->query("UPDATE funcionario SET grupoDeTrabalho = '$grupoDeTrabalho' where  idFuncionario = '$idFuncionario'");
			#$stmt ->execute();
			return true;
			
	} 

	static public function mdlActualizarCodigoParaReporSenha($idUsuario, $codigo){
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET codigoParaReporSenha = '$codigo' where idUsuario = '$idUsuario'");
		#$stmt ->execute();
		return true;
		
} 

	static public function mdlActualizarSaldoUsuario($saldo,$id){
			
		$stmt = Conexao::conectar()->query("UPDATE usuario SET saldoCOnta = '$saldo' where idUsuario = '$id'");
		#$stmt ->execute();
		return true;
		
}

	static public function mdlActualizarImagemPerfilUsuario($imagem,$id){
		$stmt = Conexao::conectar()->query("UPDATE usuario SET imagem = '$imagem' where  idUsuario = '$id'");
		#$stmt ->execute();
		return true;
	}

	static public function mdlActualizarDadosFuncionario($cargo, $grupoDeTrabalho, $instituicao, $dataTermino, $tipocargo ,$idFuncionario){

		$stmt = Conexao::conectar()->query("UPDATE funcionario SET cargo = '$cargo', grupoDeTrabalho = '$grupoDeTrabalho', instituicao = '$instituicao', dataTermino = '$dataTermino', tipocargo = '$tipocargo'  where  idFuncionario = '$idFuncionario'");
		#$stmt ->execute();
		return true;

	}

	static public function mdlDeletarUsuario($id){
		
		$Dados = Conexao::conectar()->prepare("DELETE from usuario where  idUsuario = :t ");
		$Dados->dataTerminondValue(":t",$id);
		if($Dados ->execute())
		{
			return true;
		}else{
			return false;
		}
		
			
	}
  
	static public function mdlActualizarDadosUsuario($cargo, $dataTermino, $tipocargo, $dataInicio,$id,$senha){

		$Dados = Conexao::conectar()->prepare("SELECT * from usuario where idUsuario = :t and senha = :s");
		$Dados->dataTerminondValue(":t",$id);
		$Dados->dataTerminondValue(":s",$senha);
		$Dados ->execute();
		if ($Dados ->rowCount() > 0) {
			$stmt = Conexao::conectar()->query("UPDATE usuario SET cargo = '$cargo', dataTermino = '$dataTermino', tipocargo = '$tipocargo', dataInicio = '$dataInicio' where  idUsuario = '$id'");
			#$stmt ->execute();
			return true;
			}
			else{
				return false;
			}
	} 
	static public function mdlActualizarSenhaUsuario($senhaAntiga,$id,$senhaNova){

			$Dados = Conexao::conectar()->prepare("SELECT * from usuario where idUsuario = :t and senha = :s");
			$Dados->dataTerminondValue(":t",$id);
			$Dados->dataTerminondValue(":s",$senhaAntiga);
			$Dados ->execute();
			if ($Dados ->rowCount() > 0) {
				$resultado = $Dados ->fetch();
				$stmt = Conexao::conectar()->query("UPDATE usuario SET senha = '$senhaNova' where  idUsuario = '$id'");
				#$stmt ->execute();
				return true;
			}
			else{
				return false;
			}
		}

}



  ?>